function P82_v
% Problem 8.2 :	The growth/decay of population of animal species
% v.Plot r vs. x_infinity for logistic equation


% define the series of r from 0.01 to 4 with time step of 0.01
r=0.01:0.01:4;
% Calculate x_n when n approach to the infinity.
for i=1:length(r)
    % Obtain x_n for different very large n
    y=LogiEqn(r(i),0.1);
    % Prepare the plot
    x=r(i)*ones(length(y),1);
    % Generate the plot x_infinity distribution for the given r
    plot(x,y,'r.'); hold on;
end
hold off;
axis tight; grid on; 
set(gca,'FontSize',16);
xlabel('\bfThe combined rate for reproduction and starvation (a.u.)');
ylabel('\bfThe normalized population x_n for n\rightarrow\infty');
end

function y=LogiEqn(r,x0)
%
% Calculate quadratic reccureance relations
% x_n+1=r*x_n
%

for i=1:40000
    xn=r*x0.*(1-x0);
    x0=xn;
end
y=zeros(length(x0),10000);
for i=1:10000
    xn=r*x0.*(1-x0);
    x0=xn;
    y(:,i)=xn;
end
end    